<?php
header('Content-Type: application/json');
require_once '../../config.php';

$response = ['success' => false, 'message' => ''];

if (!isset($_POST['name'], $_POST['category'], $_POST['unit'], $_POST['shop_id'], $_POST['buy_price'], $_POST['price'], $_POST['loan_price'], $_POST['quantity'])) {
    $response['message'] = 'All required fields are required';
    echo json_encode($response);
    exit;
}


$name = $_POST['name'];
$description = isset($_POST['description']) ? $_POST['description'] : '';
$category = $_POST['category'];
$unit = $_POST['unit'];
$shop_id = $_POST['shop_id'];
$buy_price = $_POST['buy_price'];
$old_price = isset($_POST['old_price']) ? $_POST['old_price'] : 0;
$price = $_POST['price'];
$loan_price = $_POST['loan_price'];
$quantity = $_POST['quantity'];

// Hifadhi cover image ikiwa ipo, vinginevyo set cover_image kuwa empty string
if (isset($_FILES['cover_image']) && $_FILES['cover_image']['error'] === UPLOAD_ERR_OK) {
    $cover_image = '../../uploads/products/' . basename($_FILES['cover_image']['name']);
    if (!move_uploaded_file($_FILES['cover_image']['tmp_name'], $cover_image)) {
        $response['message'] = 'Failed to upload cover image';
        echo json_encode($response);
        exit;
    }
} else {
    $cover_image = ''; // cover image ni optional
}

try {
    // Zima auto-commit mode
    mysqli_autocommit($conn, false);

    // Hifadhi data ya product pamoja na unit
    $stmt = $conn->prepare("INSERT INTO product (name, description, category, unit, shop_id, cover_image, buy_price, old_price, price, loan_price, quantity, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");
    if (!$stmt) {
        throw new Exception('Prepare statement failed: ' . $conn->error);
    }

    $stmt->bind_param('ssssisddddi', $name, $description, $category, $unit, $shop_id, $cover_image, $buy_price, $old_price, $price, $loan_price, $quantity);
    if (!$stmt->execute()) {
        throw new Exception('Failed to insert product: ' . $stmt->error);
    }

    $product_id = $conn->insert_id;
    $stmt->close();

    // Hifadhi gallery images ikiwa zipo
    if (isset($_FILES['gallery_images'])) {
        foreach ($_FILES['gallery_images']['tmp_name'] as $key => $tmp_name) {
            $gallery_image_path = '../../uploads/products/' . basename($_FILES['gallery_images']['name'][$key]);
            if (!move_uploaded_file($tmp_name, $gallery_image_path)) {
                throw new Exception('Failed to upload gallery image: ' . $_FILES['gallery_images']['name'][$key]);
            }

            $stmt = $conn->prepare("INSERT INTO product_gallery (product_id, image, created_at) VALUES (?, ?, NOW())");
            if (!$stmt) {
                throw new Exception('Prepare statement failed: ' . $conn->error);
            }

            $stmt->bind_param('is', $product_id, $gallery_image_path);
            if (!$stmt->execute()) {
                throw new Exception('Failed to insert gallery image: ' . $stmt->error);
            }
            $stmt->close();
        }
    }

    // Hifadhi quantity change
    $stmt = $conn->prepare("INSERT INTO quantity_changes (product_id, quantity, type, date) VALUES (?, ?, 'add', NOW())");
    if (!$stmt) {
        throw new Exception('Prepare statement failed: ' . $conn->error);
    }

    $stmt->bind_param('ii', $product_id, $quantity);
    if (!$stmt->execute()) {
        throw new Exception('Failed to insert quantity change: ' . $stmt->error);
    }
    $stmt->close();

    // Commit transaction
    mysqli_commit($conn);

    $response['success'] = true;
    $response['message'] = 'Product added successfully';
} catch (Exception $e) {
    // Rollback transaction
    mysqli_rollback($conn);
    $response['message'] = 'Error: ' . $e->getMessage();
}

// Funga connection
mysqli_autocommit($conn, true);
$conn->close();

echo json_encode($response);
?>
