<?php
header('Content-Type: application/json');
include '../../config.php'; // Inahakikisha $conn imewekwa vizuri

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $json = file_get_contents('php://input');
    $data = json_decode($json, true);

    if (isset($data['supplier_id']) && isset($data['items']) && is_array($data['items'])) {
        $supplier_id = mysqli_real_escape_string($conn, $data['supplier_id']);
        
        // Insert into stock_orders table.
        $sqlOrder = "INSERT INTO stock_orders (supplier_id) VALUES ('$supplier_id')";
        if ($conn->query($sqlOrder) === TRUE) {
            $order_id = $conn->insert_id; // Get the generated order ID.

            // Loop through each order item.
            foreach ($data['items'] as $item) {
                if (isset($item['item_name']) && isset($item['item_quantity']) && isset($item['item_price']) && isset($item['item_total'])) {
                    $item_name = mysqli_real_escape_string($conn, $item['item_name']);
                    $item_quantity = mysqli_real_escape_string($conn, $item['item_quantity']);
                    $item_price = mysqli_real_escape_string($conn, $item['item_price']);
                    $item_total = mysqli_real_escape_string($conn, $item['item_total']);
                    $sqlItem = "INSERT INTO stock_order_items (order_id, item_name, item_quantity, item_price, item_total) 
                                VALUES ('$order_id', '$item_name', '$item_quantity', '$item_price', '$item_total')";
                    if (!$conn->query($sqlItem)) {
                        echo json_encode(["success" => false, "message" => "Error inserting item: " . $conn->error]);
                        $conn->close();
                        exit();
                    }
                }
            }
            echo json_encode(["success" => true, "message" => "Order added successfully", "order_id" => $order_id]);
        } else {
            echo json_encode(["success" => false, "message" => "Error inserting order: " . $conn->error]);
        }
    } else {
        echo json_encode(["success" => false, "message" => "Invalid input data"]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
}

$conn->close();
?>
 