<?php
// Include database connection
include '../../config.php'; // Adjust the path to your database connection file

// Get the raw POST data
$data = json_decode(file_get_contents('php://input'), true);

// Check if the required fields are set
if (isset($data['sellerPhone'], $data['customerName'], $data['address'], $data['contactInfo'], $data['items'], $data['totalAmount'], $data['tax'], $data['invoiceNumber'], $data['tinNumber'], $data['vrnNumber'], $data['status'], $data['type'])) {

    // Extract invoice details with proper escaping
    $sellerPhone   = mysqli_real_escape_string($conn, $data['sellerPhone']);
    $customerName  = mysqli_real_escape_string($conn, $data['customerName']);
    $address       = mysqli_real_escape_string($conn, $data['address']);
    $contactInfo   = mysqli_real_escape_string($conn, $data['contactInfo']);
    $invoiceNumber = mysqli_real_escape_string($conn, $data['invoiceNumber']);
    $totalAmount   = $data['totalAmount'];
    $tax           = $data['tax'];
    $tinNumber     = mysqli_real_escape_string($conn, $data['tinNumber']);
    $vrnNumber     = mysqli_real_escape_string($conn, $data['vrnNumber']);
    $status        = mysqli_real_escape_string($conn, $data['status']);
    $type          = mysqli_real_escape_string($conn, $data['type']);

    // Start a transaction
    mysqli_begin_transaction($conn);

    try {
        // Insert invoice into the invoices table with new columns
        $invoiceQuery = "INSERT INTO invoices (invoice_number, seller_phone, customer_name, address, contact_info, total_amount, tax, status, tin_number, vrn_number, type) 
                         VALUES ('$invoiceNumber', '$sellerPhone', '$customerName', '$address', '$contactInfo', $totalAmount, $tax, '$status', '$tinNumber', '$vrnNumber', '$type')";

        if (!mysqli_query($conn, $invoiceQuery)) {
            throw new Exception("Error inserting invoice: " . mysqli_error($conn));
        }

        // Get the last inserted invoice ID
        $invoiceId = mysqli_insert_id($conn);

        // Insert items into the invoice_items table
        foreach ($data['items'] as $item) {
            $itemName = mysqli_real_escape_string($conn, $item['name']);
            $itemDescription = mysqli_real_escape_string($conn, $item['description']);
            $quantity = $item['quantity'];
            $price    = $item['price'];

            $itemQuery = "INSERT INTO invoice_items (invoice_id, item_name,  description, quantity, price) 
                          VALUES ($invoiceId, '$itemName', '$itemDescription', $quantity, $price)";

            if (!mysqli_query($conn, $itemQuery)) {
                throw new Exception("Error inserting item: " . mysqli_error($conn));
            }
        }

        // Commit the transaction if everything is successful
        mysqli_commit($conn);

        // Return success response
        echo json_encode(['status' => 'success', 'message' => 'Invoice created successfully']);
    } catch (Exception $e) {
        // Display error message
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields']);
}

// Close the database connection
mysqli_close($conn);
?>
