<?php
date_default_timezone_set('Africa/Dar_es_Salaam');
include '../../config.php';

header("Content-Type: application/json");

$data = json_decode(file_get_contents("php://input"));

if (
    !empty($data->user_id) && 
    isset($data->shop_id) && 
    !empty($data->type) && 
    !empty($data->amount) && 
    !empty($data->user) && 
    !empty($data->description)
) {
    $user_id = $data->user_id;
    $shopId = $data->shop_id; // Kama shop_id haipo, tunatumia 0 kutoka Flutter
    $type = $data->type;
    $amount = $data->amount;
    $user = $data->user;
    $description = $data->description;
    
    // Pata muda wa sasa katika format ya "Y-m-d H:i:s"
    $createdAt = date("Y-m-d H:i:s");

    $stmt = $conn->prepare("INSERT INTO expenses (user_id, shop_id, type, amount, user, description, created_at) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("iisdsss", $user_id, $shopId, $type, $amount, $user, $description, $createdAt);

    if ($stmt->execute()) {
        echo json_encode(["success" => true, "message" => "Matumizi yameongezwa"]);
    } else {
        echo json_encode(["success" => false, "message" => "Hitilafu imetokea"]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Tafadhali jaza taarifa zote"]);
}
?>
