<?php
include '../../config.php'; 

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = $_POST['title'] ?? '';
    $body = $_POST['body'] ?? '';

    if (empty($title) || empty($body)) {
        echo json_encode(['success' => false, 'message' => 'Title and body are required']);
        exit;
    }

    $stmt = $conn->prepare("INSERT INTO notifications (title, body, created_at) VALUES (?, ?, NOW())");
    $stmt->bind_param("ss", $title, $body);

    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Notification added successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Database error']);
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
}
?>
