<?php
header('Content-Type: application/json');
include '../config.php';

// Define the base URL for images
$baseUrl = 'https://api.almega.co.tz/';

$sql = "SELECT id, title, content, image_path, created_at FROM about_us";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $aboutUs = [];
    while ($row = $result->fetch_assoc()) {
        // Clean HTML tags and decode entities
        $cleanContent = strip_tags($row['content']); // Remove HTML tags
        $cleanContent = html_entity_decode($cleanContent); // Decode HTML entities
        $cleanContent = preg_replace("/\s+/", " ", $cleanContent); // Remove extra whitespaces and newlines

        $aboutUs[] = [
            'id' => $row['id'],
            'title' => $row['title'],
            'content' => $cleanContent,
            'imageUrl' => $baseUrl . $row['image_path'], 
            'created_at' => $row['created_at'],
        ];
    }
    echo json_encode(['status' => 'success', 'data' => $aboutUs]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'No data found']);
}

$conn->close();
?>
